﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Workflow.Runtime;
using System.Workflow.Activities;
using System.Workflow.ComponentModel;
using System.Workflow.ComponentModel.Serialization;
using System.Workflow.Runtime.Hosting;




/*  
    A simple Windows Forms application which is used as a WWF runtime host. 
    The workflow is found at the WorkflowLib assembly which is referenced by this application.
 
    This application provides an implementation of the interface IWorkflowInfo which
    is used as a communication contract between the workflow and the application.
    The communication is done by using CallExternalMethodActivity activities from the
    workflow side and the ExternalDataExchangeService local communication service.
 
    Because host application and workflow are running on different threads, some calls
    this application performs are done using Invoke(), in order to be synchronized.
 */
namespace Lessons.Workflows
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
        }


        delegate void InfoDelegate(string Text);
        private delegate void WorkflowDoneDelegate();

        WorkflowRuntime workflowRuntime = null;
        WorkflowInstance instance = null;        


        /* adds the Text to the ListBox in a synchronized manner */
        public void ProcessInfo(string Text)
        {
            if (this.InvokeRequired)
            {
                /* if synchronization is required, then re-call itself through an invoked delegate */
                InfoDelegate d = delegate(string s) { ProcessInfo(s); };
                this.Invoke(d, Text);
            }
            else
            {
                this.lboInfo.Items.Add(Text);
            }
        }

        /* arrange the user interface upon workflow termination, in a synchronized manner */
        private void WorkflowDone()
        {
            if (this.InvokeRequired)
            {
                /* if synchronization is required, then re-call itself through an invoked delegate */
                WorkflowDoneDelegate d = delegate() { WorkflowDone(); };
                this.Invoke(d);
            }
            else
            {
                btnStartWorkflow.Enabled = true;
                lboInfo.Items.Add("-----------");
            }
        }

 

        private void MainForm_Load(object sender, EventArgs e)
        { 
            workflowRuntime = new WorkflowRuntime();
 
            workflowRuntime.WorkflowCompleted += new EventHandler<WorkflowCompletedEventArgs>(WorkflowCompleted);
            workflowRuntime.WorkflowTerminated += new EventHandler<WorkflowTerminatedEventArgs>(WorkflowTerminated);

            /* setup the local communication service */
            ExternalDataExchangeService ExchangeService = new ExternalDataExchangeService();
            workflowRuntime.AddService(ExchangeService);
            WorkflowInfo workflowInfo = new WorkflowInfo(this);
            ExchangeService.AddService(workflowInfo);
 
        }

        void WorkflowCompleted(object sender, WorkflowCompletedEventArgs e)
        {
            WorkflowDone();
        }

        void WorkflowTerminated(object sender, WorkflowTerminatedEventArgs e)
        {
            WorkflowDone();
        }

        private void btnStartWorkflow_Click(object sender, EventArgs e)
        {
            btnStartWorkflow.Enabled = false;

            instance = workflowRuntime.CreateWorkflow(typeof(Lessons.Workflows.Workflow1));
            instance.Start();
        }

        private void MainForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            workflowRuntime.Dispose();
        }
    }
}





namespace Lessons.Workflows
{

    /* a class implementing the contract interface. Only one implementation is allowed */
    public class WorkflowInfo : IWorkflowInfo
    {
        MainForm form;

        public WorkflowInfo(MainForm Form)
        {
            form = Form;
        } 

        public void InformHost(string Text)
        {
            form.ProcessInfo(Text);          
        }
    }

}